#include <mega8.h>
#include <delay.h>
#include <stdio.h>
#include <i2c.h>
#include <ds1307.h>
#include <alcd.h> 
#include <rtc_ds1307.h>

#define rel PORTC.2
#define lcd PORTC.3
#define alarm PORTD.7
#define ADC_VREF_TYPE 0xC0
#define c1 PINB.4 
#define c2 PINB.5 
#define c3 PINB.6 
#define c4 PINB.7
 
//######################### Global var ##################
 eeprom unsigned char prog, pass[5];
 char buffer[32];
 unsigned char len_pass=5, pass_in[5], old_pass[5], key, op=0;
 signed temp;
 unsigned char err_cunt, err_cun_num=4, wait_scan_keypad=15; //secound
 unsigned int lcd_bl;
 unsigned char scan[4]={0XFE,0XFD,0XFB,0XF7};
 unsigned char arrkey[16]={
  1,2,3,15,
  4,5,6,14,
  7,8,9,13,
  10,0,11,12};
//######################### Global var ##################

//________***** ## read adc    ADC ## *****________
  unsigned int read_adc(unsigned char adc_input){
    ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
    delay_us(10);
    ADCSRA|=0x40;
    while ((ADCSRA & 0x10)==0);
    ADCSRA|=0x10;
    return ADCW;
  }

//________***** ## get temp   ## *****________
  
  void get_temp(){
   signed int a,b;
   float t1,t2;
   b=read_adc(0);
   a=read_adc(1);
   t1=((b*2.56)/1023)*100;
   t2=((a*2.56)/1023)*100;
   temp=t1-t2;
  }

//________***** ## display    Ԑ ## *****________
  
  void display(){
    get_temp();
    sprintf(buffer,"%d\xdfC %d:%d:%d\n%d/%d/%d",temp,hour,minute,second,jy,jm,jd);
    lcd_clear();
    lcd_puts(buffer);
    week_name();
    cunter_err_pass(err_cunt);
  }

//________***** ## lcd_back_light      ## *****________

  void lcd_back_light(){
    lcd_bl++;
    if(lcd_bl>=250) lcd=0;
      else lcd=1;
  }

//________***** ## keypad Ә  ## *****________
  
  unsigned char keypad(unsigned char wait){
  unsigned char r,c,k=0,j;
  unsigned int i,l;
   DDRB=0X0F;
   PORTB=0XFF; 
   l=(wait*1000)+1000;
   
      for (i=0; i<l; i++){
        for (r=0; r<4; r++){
         c=4;
         PORTB=scan[r];
         delay_us(10);
         if(c1==0) c=0;
         if(c2==0) c=1;
         if(c3==0) c=2;
         if(c4==0) c=3;
         
          if (!(c==4)){
           k=arrkey[(r*4)+c];
           while(c1==0);
           while(c2==0);
           while(c3==0);
           while(c4==0);
           delay_ms(100);
           lcd_bl=0;
           return k;
          }
        }
        delay_ms(1);
        j++;
        if(j==100) {lcd_back_light(); j=0;}
      } 
   
   k=100; //time out  "Not press any key" 
   return k;  
  }

//________***** ## reset_var     ## *****________
  
  void reset_var(){ 
    unsigned char i;
    for (i=0; i<len_pass; i++){
      pass_in[i]=255;
      old_pass[i]=255;
    }
  }

//________***** ## masage    ## *****________
 
  unsigned char masage(){
    lcd_clear();
    lcd_gotoxy(5,0);
    lcd_putsf("SAVE?");
    lcd_gotoxy(0,1);
    lcd_putsf("NO(*)");
    lcd_gotoxy(10,1);
    lcd_putsf("YES(#)");
    key = keypad(wait_scan_keypad);
    return key;
  }  

//________***** ## get_pass    ## *****________

  void get_pass(){
    unsigned char i,x;
  res_get_pass:  
    lcd_clear();
    _lcd_write_data(0X0F);
    if(op==0) lcd_putsf("Input Password");
    if(op==1) lcd_putsf("Old Password");
    if(op==2) lcd_putsf("New Password");
    for (i=0; i<len_pass; i++){
        x=i+5;
        lcd_gotoxy(x,1);
        key = keypad(wait_scan_keypad);
        if(key==10) goto res_get_pass;
        if(key==100 || key==11) break;
        pass_in[i]=key;
        sprintf(buffer,"%d",pass_in[i]);
        lcd_puts(buffer);
        delay_ms(150);
        lcd_gotoxy(x,1);
        lcd_putsf("*");
    }
  }  

//________***** ## new_pass          ## *****________
  
  void new_pass(){
    unsigned char i;
    lcd=1;
    if(prog!=80){ // Create a first password
        sprintf(buffer,"Admin: Create a password");
        lcd_clear();
        lcd_puts(buffer);
        delay_ms(3000);
        get_pass();
        i=masage();
        
      if(i==11){
        for (i=0; i<len_pass; i++){
            pass[i]=pass_in[i];
        }
        prog=80; // burn fuse for a first get password 
      }
    }
    reset_var();
  }  

//________***** ## check_pass        ## *****________
  
  void check_pass(unsigned char open){ //open: 1=> rel=1
    unsigned char i,c=1;
    for (i=0; i<len_pass; i++){
        if(pass_in[i]!=pass[i]){
            c++;
            break;
        }
    }
    
    if(c==1){
      if(open==1){  
        rel=1; //cunter for wait invalid password
        lcd_clear();
        lcd_putsf("Opened the door");
        lcd_gotoxy(4,1);
        lcd_putsf("WELCOME");
        delay_ms(500);
        rel=0;
        delay_ms(2000);
      }
      err_cunt=err_cun_num;
      op=50; //op 50 ==> password is true and chane time date
    }else{
       lcd_clear();
       lcd_putsf("INVALID PASSWORD");
       delay_ms(1000);
       err_cunt--;
    }
   reset_var();
  }

//________***** ## change_pass   ## *****________
  
  void change_pass(){
    unsigned char i,c=1;
    op=1; //get old password
    get_pass();
    for (i=0; i<len_pass; i++){
        old_pass[i]=pass_in[i];
    }
    op=2; //get new password
    get_pass();
    
    for (i=0; i<len_pass; i++){
        if(old_pass[i]!=pass[i]){
            c++;
            break;
        }
    }
    
    key = masage();
    if(key==11){//# key==11 save is OK Go to cheking... 

       if(c==1){
          for(i=0; i<len_pass; i++){
            pass[i]=pass_in[i];
          }
          lcd_clear();
          lcd_putsf("Successfully !");
          delay_ms(3000);
          err_cunt=err_cun_num; //cunter for wait invalid password
        }else{
           lcd_clear();
           lcd_putsf("ERROR!   Wait...");
           delay_ms(5000);
           err_cunt--;
        }
        
    }
    reset_var(); key=0; 
 }

//________***** ## change_time    ## *****________ 

  void change_time(){
    unsigned char digit[2],newtime[6];    //0h,1m,2s  3y,4mo,5d
    unsigned char x,y=0,j,locate[6]={5,8,11,5,8,13};
    get_pass();
    check_pass(0);
    if(op==50){ //op 50 ==> password is true and chane time is alow
      sprintf(buffer,"Time --:--:--\nDate --/--/20--");
      lcd_clear();
      lcd_puts(buffer);
      _lcd_write_data(0X0F);
      
      for(x=0; x<=5; x++){ //get 6 number
        digit[0]=digit[1]=0;
        if(x>2) y=1; // Go to next row
        for(j=0; j<=1; j++){ //get 2 digit from keypad 
          lcd_gotoxy(locate[x],y);
          digit[j]=keypad(wait_scan_keypad);
          if(j==0) digit[0]*=10; //Digit format xx => digit[0]x
          newtime[x]=digit[0]+digit[1]; //Ӂ      Ԙ  
          if(digit[j]!=100){ //chek for time out keypad
            sprintf(buffer,"%d",newtime[x]);
            lcd_puts(buffer);
          }else goto endTime; //esc
        }
      } 
      key=masage();
      if(key==11){
        gregorian_week_day(newtime[3],newtime[4],(newtime[5]+2000)); //calculate week day
        rtc_set_time(newtime[0],newtime[1],newtime[2]);   //hour, min, sec  //0h,1m,2s  
        rtc_set_date(week,newtime[3],newtime[4],newtime[5]); //week_day, day ,month, year //3y,4mo,5d
      }else if(key==10) goto endTime;
    }
   endTime:
   key=op=0;  
  }
    
//________***** ## Main   ## *****________ 

  void main(void){
    unsigned char a,b;
    lcd=1;
    lcd_init(16);
    
    PORTC=0x00;
    DDRC.2=1;
    DDRC.3=1;
    PORTD=0x00;
    DDRD.7=1; 
    
    err_cunt=err_cun_num;
    new_pass();
    
    i2c_init();
    rtc_init(0,0,0);

    ACSR=0x80;
    SFIOR=0x00;
    ADMUX=ADC_VREF_TYPE & 0xff;
    ADCSRA=0x87;

    while (1){
     lcd_back_light();
     get_rtc();
     key=0xFF;op=0; //restr this var
         if(err_cunt==0){ //wait for error
            lcd_clear();
            lcd_gotoxy(3,0);
            lcd_putsf("ERROR ...");
            lcd_gotoxy(0,1);
            lcd_putsf("You Don't Input");
            alarm=1; delay_ms(500); alarm=0; delay_ms(300);
            alarm=1; delay_ms(500); alarm=0; delay_ms(300);
            alarm=1; delay_ms(2000); alarm=0;
            
            for (a=0; a<15; a++){
               for (b=0; b<60; b++){ // 1 min
                 lcd_gotoxy(15,0);
                 lcd_putsf("|");
                 delay_ms(300);
                 lcd_gotoxy(15,0);
                 lcd_putsf("/");
                 delay_ms(300);
                 lcd_gotoxy(15,0);
                 lcd_putsf("-");
                 delay_ms(300);
               }
            }
          err_cunt=err_cun_num;
         }
     display();
     key = keypad(0);
      
      if(key==1) change_time();
      if(key==10) change_pass();
      if(key==11){
        get_pass();
        if(key!=100) check_pass(1); //if: no time out then open=1
      }
    }
 }